/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.google.zxing.WriterException;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.InfoClientDTO;
import com.hpay.hpay_mobile_api.DTO.LoginClientValidationRequest;
import com.hpay.hpay_mobile_api.DTO.LoginRequest;
import com.hpay.hpay_mobile_api.DTO.PasswordChangeRequest;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.services.AuthService;
import com.hpay.hpay_mobile_api.services.CompteService;
import com.hpay.hpay_mobile_api.services.S3Service;
import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;
    @Autowired
    private S3Service s3Service;
    @Autowired
    private CompteService compteService;
    @Value(value="${client.photo.upload-dir}")
    private String uploadDir;

    @Operation(summary="Retourne un message de bienvenue", description="Renvoie un message de bienvenue en fran\u00e7ais.")
    @PostMapping(value={"/signup"})
    public ResponseEntity<Object> signup(@RequestBody LoginRequest loginRequest) throws IOException, WriterException {
        Object response = this.authService.signup(loginRequest);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)201).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/signin"})
    public ResponseEntity<Object> signin(@RequestBody LoginRequest loginRequest) throws IOException, WriterException {
        Object response = this.authService.signin(loginRequest.getLogin(), loginRequest.getPassword());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/validate"})
    public ResponseEntity<Object> validateLoginClient(@RequestBody LoginClientValidationRequest request) {
        Object response = this.authService.validateLoginClient(request.getIdLoginClient(), request.getActivationCode());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/updateActivationCode/{idLoginClient}"})
    public ResponseEntity<Object> updateActivationCode(@PathVariable Long idLoginClient) {
        Object response = this.authService.updateActivationCode(idLoginClient);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/infoClient/{idClient}"})
    public ResponseEntity<Object> updateClient(@PathVariable Long idClient, @RequestBody InfoClientDTO clientUpdateRequest) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parsedDate = dateFormat.parse(clientUpdateRequest.getDateNaissance());
        Object response = this.authService.updateClientInfo(idClient, clientUpdateRequest.getNom(), clientUpdateRequest.getPrenoms(), clientUpdateRequest.getSex(), parsedDate, clientUpdateRequest.getLieuNaissance());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/2faemail/{idClient}/{email}"})
    public Object updateEmail(@PathVariable Long idClient, @PathVariable String email) {
        Object response = this.authService.updateEmail(idClient, email);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/upload-photo/{clientId}"})
    public Object uploadClientPhoto(@PathVariable Long clientId, @RequestParam(value="photo") MultipartFile photo) throws IOException, ParseException {
        Object response = this.authService.uploadClientPhoto(clientId, photo);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"photos/{filename}"})
    public ResponseEntity<FileSystemResource> getPhoto(@PathVariable String filename) {
        System.out.println("iccciiii");
        System.out.println(filename);
        File file = new File(this.uploadDir + "\\" + filename);
        if (file.exists()) {
            String fileExtension = this.getFileExtension(file);
            System.out.println("existe");
            String contentType = "application/octet-stream";
            if (fileExtension.equals("jpg") || fileExtension.equals("jpeg")) {
                contentType = "image/jpeg";
            } else if (fileExtension.equals("png")) {
                contentType = "image/png";
            } else if (fileExtension.equals("gif")) {
                contentType = "image/gif";
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", contentType);
            return new ResponseEntity((Object)new FileSystemResource(file), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        System.out.println("existe pas");
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"client/{id}"})
    public Object getClientById(@PathVariable long id) {
        Object response = this.authService.fetchClient(id);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @DeleteMapping(value={"/{id}"})
    public Object deleteClient(@PathVariable Long id) {
        Object response = this.authService.deleteLoginClient(id);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/validate/email"})
    public ResponseEntity<Object> validateEmailClient(@RequestBody LoginClientValidationRequest request) {
        Object response = this.authService.validateEmailClient(request.getIdLoginClient(), request.getActivationCode());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"passwordforgot/requestcode/{userName}"})
    public Object getClientById(@PathVariable String userName) {
        Object response = this.authService.passwordforgetRequest(userName);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"passwordforgot/validatecode/{phone}/{code}"})
    public Object requestPasswordForget(@PathVariable String phone, @PathVariable String code) {
        Object response = this.authService.validatePasswordForgotCode(phone, code);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"passwordforgot/update/{phone}/{password}"})
    public Object updatePasswordForget(@PathVariable String phone, @PathVariable String password) {
        Object response = this.authService.changepassword(phone, password);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/passwordchange"})
    public ResponseEntity<Object> changePassword(@RequestBody PasswordChangeRequest request) {
        Object response = this.authService.changePasswordWithOldPassword(request.getId(), request.getOldpassword(), request.getNewpassword());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"client/search/{phone}"})
    public Object getClientByPhone(@PathVariable String phone) {
        Object response = this.authService.fetchClientByPhone(phone);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"addparrainage/{phoneparainee}/{phoneparain}"})
    public Object addParrairage(@PathVariable String phoneparainee, @PathVariable String phoneparain) {
        Object response = this.authService.addParrainage(phoneparainee, phoneparain);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"images/charger"})
    public ResponseEntity<String> uploadImage(@RequestParam(value="file") MultipartFile file) {
        try {
            String message = this.s3Service.uploadImage(file);
            return ResponseEntity.ok((Object)message);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("Erreur lors du t\u00e9l\u00e9chargement : " + e.getMessage()));
        }
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        String extension = "";
        int i = name.lastIndexOf(46);
        if (i > 0) {
            extension = name.substring(i + 1);
        }
        return extension.toLowerCase();
    }

    @GetMapping(value={"client/parrain/{code}"})
    public Object getClientByCodeParrainage(@PathVariable String code) {
        Object response = this.authService.fetchClientByCodeParrainage(code);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/generate"})
    public String generateQRCode(@RequestParam String text, @RequestParam String fileName) {
        try {
            return this.s3Service.generateQRCodeAndUploadToS3(text, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error generating QR code: " + e.getMessage();
        }
    }

    @PostMapping(value={"/sendEmail/valider"})
    public ResponseEntity<Object> sendEmailValiderClient(@RequestBody LoginClientValidationRequest request) {
        Object response = this.authService.sendEmailValiderClient(request.getIdLoginClient());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/sendEmail/confirm/account"})
    public ResponseEntity<Object> AccountCreatedConfirm(@RequestBody LoginClientValidationRequest request) {
        Object response = this.authService.accountCreatedConfirm(request.getIdLoginClient());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"/generate-num"})
    public ResponseEntity<String> generateNumCompte() {
        String numCompte = this.compteService.generateUniqueNumCompte();
        return ResponseEntity.ok((Object)numCompte);
    }
}

