/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.entities.Compte;
import com.hpay.hpay_mobile_api.repositories.CompteRepository;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompteService {
    @Autowired
    private CompteRepository compteRepository;

    public List<Compte> getAllComptes() {
        return this.compteRepository.findAll();
    }

    public Optional<Compte> getCompteById(Long id) {
        return this.compteRepository.findById(id);
    }

    public Compte createCompte(Compte compte) {
        return (Compte)this.compteRepository.save(compte);
    }

    public void deleteCompte(Long id) {
        this.compteRepository.deleteById(id);
    }

    public String generateUniqueNumCompte() {
        String numCompte;
        boolean exists;
        do {
            if (!(exists = this.compteRepository.existsByNumCompte(numCompte = this.generateTimeBasedNum()))) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted while generating numCompte", e);
            }
        } while (exists);
        try {
            TimeUnit.MILLISECONDS.sleep(1005L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while generating numCompte", e);
        }
        return numCompte;
    }

    private String generateTimeBasedNum() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
        return formatter.format(new Date());
    }

    public Optional<Compte> findById(Long id) {
        return this.compteRepository.findById(id);
    }
}

