/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.entities.ParrainCode;
import com.hpay.hpay_mobile_api.repositories.ParrainCodeRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParrainCodeService {
    private final ParrainCodeRepository parrainCodeRepository;

    @Autowired
    public ParrainCodeService(ParrainCodeRepository parrainCodeRepository) {
        this.parrainCodeRepository = parrainCodeRepository;
    }

    public List<ParrainCode> getAllParrainCodes() {
        return this.parrainCodeRepository.findAll();
    }

    public Optional<ParrainCode> getParrainCodeById(Long id) {
        return this.parrainCodeRepository.findById(id);
    }

    public ParrainCode createParrainCode(ParrainCode parrainCode) {
        return (ParrainCode)this.parrainCodeRepository.save(parrainCode);
    }

    public ParrainCode updateParrainCode(Long id, ParrainCode parrainCode) {
        if (this.parrainCodeRepository.existsById(id)) {
            parrainCode.setIdCode(id);
            return (ParrainCode)this.parrainCodeRepository.save(parrainCode);
        }
        return null;
    }

    public boolean deleteParrainCode(Long id) {
        if (this.parrainCodeRepository.existsById(id)) {
            this.parrainCodeRepository.deleteById(id);
            return true;
        }
        return false;
    }

    public ParrainCode getParrainCodeByCodeParrainage(String codeParrainage) {
        return this.parrainCodeRepository.findByCodeParrainage(codeParrainage);
    }
}

