/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.PaysDTO;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Pays;
import com.hpay.hpay_mobile_api.repositories.PayRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayService {
    private final PayRepository payRepository;

    @Autowired
    public PayService(PayRepository payRepository) {
        this.payRepository = payRepository;
    }

    public List<Pays> getAllPays() {
        return this.payRepository.findAll();
    }

    public Optional<Pays> getPayById(Integer id) {
        return this.payRepository.findById(id);
    }

    public Pays createPay(Pays pay) {
        return (Pays)this.payRepository.save(pay);
    }

    public Pays updatePay(Integer id, Pays payDetails) {
        Pays existingPay = (Pays)this.payRepository.findById(id).orElseThrow(() -> new RuntimeException("Pay not found"));
        existingPay.setPays(payDetails.getPays());
        existingPay.setIndicatif(payDetails.getIndicatif());
        existingPay.setPaysIso(payDetails.getPaysIso());
        existingPay.setPaysCode(payDetails.getPaysCode());
        return (Pays)this.payRepository.save(existingPay);
    }

    public void deletePay(Integer id) {
        this.payRepository.deleteById(id);
    }

    public List<Pays> getPayByName(String pays) {
        return this.payRepository.findByPays(pays);
    }

    public Object getAllPaysWithoutVilles() {
        List<PaysDTO> data = this.payRepository.findAllPaysWithoutVilles();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        return new SuccessResponse("list found", 200, map);
    }
}

