/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.DTO.SochitelRequest;
import com.hpay.hpay_mobile_api.DTO.SochitelResponseDto;
import com.hpay.hpay_mobile_api.entities.Sochitel;
import com.hpay.hpay_mobile_api.services.SochitelService;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sochitel"})
public class SochitelController {
    private final SochitelService sochitelService;

    @GetMapping(value={"/transactions"})
    public Page<SochitelResponseDto> getTransactions(@RequestParam(required=false) Integer idClient, @RequestParam(required=false) Integer idCompte, @RequestParam(required=false) LocalDateTime dateStart, @RequestParam(required=false) LocalDateTime dateEnd, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="desc") String sortDirection) {
        return this.sochitelService.getTransactions(idClient, idCompte, dateStart, dateEnd, page, size, sortDirection);
    }

    @PostMapping(value={"/insert"})
    public ResponseEntity<Sochitel> create(@Valid @RequestBody SochitelRequest request) {
        Sochitel saved = this.sochitelService.insert(request);
        return ResponseEntity.ok((Object)saved);
    }

    public SochitelController(SochitelService sochitelService) {
        this.sochitelService = sochitelService;
    }
}

