/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.amazonaws.services.s3.AmazonS3;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.KycSaveRequest;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.Enum.KycStatus;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.entities.LoginClient;
import com.hpay.hpay_mobile_api.entities.Pays;
import com.hpay.hpay_mobile_api.entities.Ville;
import com.hpay.hpay_mobile_api.repositories.ClientRepository;
import com.hpay.hpay_mobile_api.repositories.LoginClientRepository;
import com.hpay.hpay_mobile_api.repositories.PayRepository;
import com.hpay.hpay_mobile_api.repositories.VilleRepository;
import com.hpay.hpay_mobile_api.services.PhotoService;
import com.hpay.hpay_mobile_api.utils.SendEmail;
import jakarta.mail.MessagingException;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KycService {
    @Autowired
    private LoginClientRepository loginClientRepository;
    @Autowired
    private ClientRepository clientRepository;
    @Value(value="${aws.s3.bucketName}")
    private String bucketName;
    @Value(value="${client.photo.upload-dir}")
    private String uploadDir;
    @Value(value="${client.photo.base-url}")
    private String photoBaseUrl;
    private final AmazonS3 amazonS3;
    @Autowired
    private VilleRepository villeRepository;
    @Autowired
    private PayRepository payRepository;
    @Autowired
    private PhotoService photoService;

    public KycService(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    @Transactional
    public Object saveKycInfo(KycSaveRequest request) throws IOException, ParseException {
        LoginClient loginClient = this.loginClientRepository.findById(request.getId()).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (this.clientRepository.existsByNumPiece(request.getNumero_id())) {
            return new ErrorResponse("used number", 404);
        }
        Pays pays = this.payRepository.findById(request.getPays_id()).orElse(null);
        if (pays == null) {
            return new ErrorResponse("Pays not found", 409);
        }
        Ville ville = this.villeRepository.findById(request.getVille_id()).orElse(null);
        if (ville == null) {
            return new ErrorResponse("Pays not found", 409);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parsedDate = dateFormat.parse(request.getDate_naiss());
        Date parsedDateExp = dateFormat.parse(request.getDate_exp());
        Client client = loginClient.getClient();
        client.setNom(request.getNom());
        client.setPrenoms(request.getPrenom());
        client.setDateNaissance(parsedDate);
        client.setAdresse(request.getAddress());
        client.setNationalite(request.getNationalite());
        client.setSexe(request.getGenre());
        client.setPays(pays);
        client.setVille(ville);
        client.setNationalite(request.getNationalite());
        client.setLieuNaissane(request.getLieu_naiss());
        client.setTelephone(request.getTelephone1());
        client.setTelephone2(request.getTelephone2());
        client.setExpirePiece(parsedDateExp);
        client.setNumPiece(request.getNumero_id());
        client.setIdTypePiece(request.getId_type());
        client.setPieceCni(request.getId_type());
        client.setNumPieceCni(request.getNumero_id());
        client.setValider("0");
        String rectoUrl = this.photoService.uploadPhoto(request.getRecto());
        client.setPhotoPieceRecto(rectoUrl);
        if (request.getVerso() != null) {
            String versoUrl = this.photoService.uploadPhoto(request.getVerso());
            client.setPhotoPieceVerso(versoUrl);
        }
        loginClient.setClient(client);
        loginClient.setKycStatus(String.valueOf((Object)KycStatus.EN_ATTENTE));
        loginClient = (LoginClient)this.loginClientRepository.save(loginClient);
        try {
            SendEmail.sendNewKycNotification(client.getPrenoms() + " " + client.getNom(), String.valueOf(client.getId()), loginClient.getLogin());
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", loginClient);
        return new SuccessResponse("kyc save succesffully", 200, map);
    }

    @Transactional
    public Object UpdateKycStatus(Long idClient, String status) {
        LoginClient loginClient = this.loginClientRepository.findById(idClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (!(status.equals("VALIDE") || status.equals("NON_SOUMIS") || status.equals("NON_VALIDE") || status.equals("EN_ATTENTE"))) {
            return new ErrorResponse("Status not found", 404);
        }
        loginClient.setKycStatus(status);
        loginClient = (LoginClient)this.loginClientRepository.save(loginClient);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", loginClient);
        return new SuccessResponse("kyc save succesffully", 200, map);
    }
}

