/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.QuerySpecifications;

import com.hpay.hpay_mobile_api.entities.VirementInterne;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.springframework.data.jpa.domain.Specification;

public class VirementInterneSpecification {
    public static Specification<VirementInterne> withFilters(Long idClient, Long idCompte, LocalDateTime startDate, LocalDateTime endDate) {
        return (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (idClient != null) {
                Predicate fromPredicate = cb.equal((Expression)root.get("idClientFrom"), (Object)idClient);
                Predicate toPredicate = cb.equal((Expression)root.get("idClientTo"), (Object)idClient);
                Predicate finalPredicate = cb.or((Expression)fromPredicate, (Expression)toPredicate);
                predicates.add(finalPredicate);
            }
            if (idCompte != null) {
                Predicate fromComptePredicate = cb.equal((Expression)root.get("idCompteFrom"), (Object)idCompte);
                Predicate toComptePredicate = cb.equal((Expression)root.get("idCompteTo"), (Object)idCompte);
                Predicate finalComptePredicate = cb.or((Expression)fromComptePredicate, (Expression)toComptePredicate);
                predicates.add(finalComptePredicate);
            }
            if (startDate != null && endDate != null) {
                predicates.add(cb.between((Expression)root.get("dateInitiale"), (Comparable)startDate, (Comparable)endDate));
            } else if (startDate != null) {
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get("dateInitiale"), (Comparable)startDate));
            } else if (endDate != null) {
                predicates.add(cb.lessThanOrEqualTo((Expression)root.get("dateInitiale"), (Comparable)endDate));
            }
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }
}

