/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.DTO.CarteClientQrDTO;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.services.CarteClientQrService;
import com.hpay.hpay_mobile_api.services.CompteService;
import com.hpay.hpay_mobile_api.services.TypeCompteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/compte"})
public class CompteController {
    @Autowired
    private CompteService compteService;
    @Autowired
    private TypeCompteService typeCompteService;
    @Autowired
    private CarteClientQrService carteClientQrService;

    @PostMapping(value={"/addCarte/{idCompte}/{idLoginClient}"})
    public ResponseEntity<Object> ajouterCarte(@PathVariable Long idCompte, @PathVariable Long idLoginClient, @RequestBody CarteClientQrDTO carteClientQrDTO) {
        Object response = this.carteClientQrService.ajouterCarteAuCompte(idCompte, idLoginClient, carteClientQrDTO);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/modifyPin/{idCompte}/{idLoginClient}"})
    public ResponseEntity<Object> modifyPinCarte(@PathVariable Long idCompte, @PathVariable Long idLoginClient, @RequestBody CarteClientQrDTO carteClientQrDTO) {
        Object response = this.carteClientQrService.modifyPinCompte(idCompte, idLoginClient, carteClientQrDTO);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/deleteCarte/{idcarteClientQr}/{idLoginClient}"})
    public ResponseEntity<Object> deleteCarte(@PathVariable Long idcarteClientQr, @PathVariable Long idLoginClient, @RequestBody CarteClientQrDTO carteClientQrDTO) {
        Object response = this.carteClientQrService.removeCardCompte(idcarteClientQr, idLoginClient, carteClientQrDTO);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @PostMapping(value={"/toggleActive/{idCompte}/{idLoginClient}"})
    public ResponseEntity<Object> toggleActiveCompte(@PathVariable Long idCompte, @PathVariable Long idLoginClient, @RequestBody CarteClientQrDTO carteClientQrDTO) {
        Object response = this.carteClientQrService.toggleActiveCompte(idCompte, idLoginClient, carteClientQrDTO);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> getCompteById(@PathVariable Long id) {
        return this.compteService.findById(id).map(compte -> ResponseEntity.ok((Object)compte)).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

