/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.security;

import com.hpay.hpay_mobile_api.security.JwtTokenUtil;
import com.hpay.hpay_mobile_api.services.AuthService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtRequestFilter
extends OncePerRequestFilter {
    private final JwtTokenUtil jwtTokenUtil;
    private final AuthService authService;

    public JwtRequestFilter(JwtTokenUtil jwtTokenUtil, AuthService authService) {
        this.jwtTokenUtil = jwtTokenUtil;
        this.authService = authService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String token = request.getHeader("Authorization");
        String username = null;
        if (token != null && token.startsWith("Bearer ")) {
            token = token.substring(7).trim();
            username = this.jwtTokenUtil.extractUsername(token);
        }
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(username, null, new ArrayList());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

