/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Beneficiaire;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.entities.LoginClient;
import com.hpay.hpay_mobile_api.repositories.BeneficiaireRepository;
import com.hpay.hpay_mobile_api.repositories.ClientRepository;
import com.hpay.hpay_mobile_api.repositories.LoginClientRepository;
import com.hpay.hpay_mobile_api.services.ClientService;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeneficiaireService {
    @Autowired
    private LoginClientRepository loginClientRepository;
    @Autowired
    private ClientRepository clientRepository;
    @Autowired
    private BeneficiaireRepository beneficiaireRepository;
    @Autowired
    private ClientService clientService;

    @Transactional
    public Object AddBenef(Long idClient, Long idBeneficiaire) {
        LoginClient loginClient = this.loginClientRepository.findById(idClient).orElse(null);
        LoginClient loginBeneficiaire = this.loginClientRepository.findById(idBeneficiaire).orElse(null);
        Date currentDate = new Date();
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (loginBeneficiaire == null) {
            return new ErrorResponse("Beneficiaire not found", 404);
        }
        Beneficiaire existingBeneficiaire = this.beneficiaireRepository.findByClientIdAndBeneficiaireId(loginClient.getClient().getId(), loginBeneficiaire.getClient().getId()).orElse(null);
        if (existingBeneficiaire != null) {
            System.out.println("trouver");
            return new ErrorResponse("Already added", 404);
        }
        Beneficiaire beneficiaire = new Beneficiaire();
        beneficiaire.setClient(loginClient.getClient());
        beneficiaire.setBeneficiaire(loginBeneficiaire.getClient());
        beneficiaire.setDateAjout(currentDate);
        this.beneficiaireRepository.save(beneficiaire);
        List<Beneficiaire> beneficiaires = this.beneficiaireRepository.findByClientId(loginClient.getClient().getId());
        ArrayList list = new ArrayList();
        for (Beneficiaire benef : beneficiaires) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", benef.getBeneficiaire().getId());
            map1.put("telephone", benef.getBeneficiaire().getTelephone());
            map1.put("nom", benef.getBeneficiaire().getNom());
            map1.put("prenoms", benef.getBeneficiaire().getPrenoms());
            map1.put("sexe", benef.getBeneficiaire().getSexe());
            map1.put("compte", benef.getBeneficiaire().getComptes());
            map1.put("photo", benef.getBeneficiaire().getPhotoClient());
            list.add(map1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", list);
        return new SuccessResponse("beneficiary successfully added", 200, map);
    }

    public Object getBeneficiaires(Long idClient) {
        LoginClient loginClient = this.loginClientRepository.findById(idClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        List<Beneficiaire> beneficiaires = this.beneficiaireRepository.findByClientId(loginClient.getClient().getId());
        ArrayList list = new ArrayList();
        for (Beneficiaire benef : beneficiaires) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", benef.getBeneficiaire().getId());
            map1.put("telephone", benef.getBeneficiaire().getTelephone());
            map1.put("nom", benef.getBeneficiaire().getNom());
            map1.put("prenoms", benef.getBeneficiaire().getPrenoms());
            map1.put("sexe", benef.getBeneficiaire().getSexe());
            map1.put("compte", benef.getBeneficiaire().getComptes());
            map1.put("photo", benef.getBeneficiaire().getPhotoClient());
            list.add(map1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", list);
        return new SuccessResponse("beneficiary successfully added", 200, map);
    }

    @Transactional
    public Object removeBeneficiaire(Long clientId, Long beneficiaireId) {
        Beneficiaire existingBeneficiaire = this.beneficiaireRepository.findByClientIdAndBeneficiaireId(clientId, beneficiaireId).orElse(null);
        if (existingBeneficiaire == null) {
            System.out.println("trouver");
            return new ErrorResponse("not Found", 404);
        }
        this.beneficiaireRepository.delete(existingBeneficiaire);
        List<Beneficiaire> beneficiaires = this.beneficiaireRepository.findByClientId(clientId);
        ArrayList list = new ArrayList();
        for (Beneficiaire benef : beneficiaires) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", benef.getBeneficiaire().getId());
            map1.put("telephone", benef.getBeneficiaire().getTelephone());
            map1.put("nom", benef.getBeneficiaire().getNom());
            map1.put("prenoms", benef.getBeneficiaire().getPrenoms());
            map1.put("sexe", benef.getBeneficiaire().getSexe());
            map1.put("compte", benef.getBeneficiaire().getComptes());
            map1.put("photo", benef.getBeneficiaire().getPhotoClient());
            list.add(map1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", list);
        return new SuccessResponse("beneficiary successfully added", 200, map);
    }

    @Transactional
    public Object getContactsClient(Long clientId, List<Integer> phones) {
        LoginClient loginClient = this.loginClientRepository.findById(clientId).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        List<Beneficiaire> beneficiaires = this.beneficiaireRepository.findBeneficiariesByClientId(loginClient.getClient().getId());
        ArrayList<Long> dbBenefIdList = new ArrayList<Long>();
        for (Beneficiaire benef : beneficiaires) {
            dbBenefIdList.add(benef.getBeneficiaire().getId());
        }
        List<Long> benefIdList = this.clientService.getClientIdsByPhoneNumbers(phones);
        List benefList = benefIdList.stream().filter(clientIdInList -> !dbBenefIdList.contains(clientIdInList)).map(clientIdInList -> this.clientRepository.findById(clientIdInList).orElse(null)).filter(client -> client != null).collect(Collectors.toList());
        ArrayList list = new ArrayList();
        for (Client client2 : benefList) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", client2.getId());
            map1.put("telephone", client2.getTelephone());
            map1.put("nom", client2.getNom());
            map1.put("prenoms", client2.getPrenoms());
            map1.put("sexe", client2.getSexe());
            map1.put("compte", client2.getComptes());
            map1.put("photo", client2.getPhotoClient());
            list.add(map1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", list);
        return new SuccessResponse("Additional client to add", 200, map);
    }

    @Transactional
    public Object addBeneficiairesToClient(Long loginClientId, List<Integer> beneficiaireIds) {
        LoginClient loginClient = this.loginClientRepository.findById(loginClientId).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        for (Integer beneficiaireId : beneficiaireIds) {
            Client beneficiaireClient = this.clientRepository.findById(beneficiaireId).orElse(null);
            Beneficiaire existingBeneficiaire = this.beneficiaireRepository.findByClientIdAndBeneficiaireId(loginClient.getClient().getId(), (long)beneficiaireId).orElse(null);
            if (existingBeneficiaire != null || beneficiaireClient == null) continue;
            Beneficiaire beneficiaire = new Beneficiaire();
            beneficiaire.setClient(loginClient.getClient());
            beneficiaire.setBeneficiaire(beneficiaireClient);
            beneficiaire.setDateAjout(new Date());
            this.beneficiaireRepository.save(beneficiaire);
            System.out.println("added " + String.valueOf(beneficiaireIds));
        }
        List<Beneficiaire> beneficiaires = this.beneficiaireRepository.findByClientId(loginClient.getClient().getId());
        ArrayList list = new ArrayList();
        for (Beneficiaire benef : beneficiaires) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", benef.getBeneficiaire().getId());
            map1.put("telephone", benef.getBeneficiaire().getTelephone());
            map1.put("nom", benef.getBeneficiaire().getNom());
            map1.put("prenoms", benef.getBeneficiaire().getPrenoms());
            map1.put("sexe", benef.getBeneficiaire().getSexe());
            map1.put("compte", benef.getBeneficiaire().getComptes());
            map1.put("photo", benef.getBeneficiaire().getPhotoClient());
            list.add(map1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", list);
        return new SuccessResponse("beneficiary successfully added", 200, map);
    }
}

