/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PhotoService {
    @Value(value="${client.photo.upload-dir}")
    private String uploadDir;
    @Value(value="${client.photo.profile.upload-dir}")
    private String clientPhotoUploadDir;
    @Value(value="${client.qr.parrainage.upload-dir}")
    private String clientQrParrainageUploadDir;
    @Value(value="${client.photo.base-url}")
    private String photoBaseUrl;
    @Value(value="${client.photo.profile.base-url}")
    private String clientPhotoBaseUrl;

    public String uploadPhoto(MultipartFile photo) throws IOException {
        File dir = new File(this.uploadDir);
        if (!dir.exists()) {
            boolean bl = dir.mkdirs();
        }
        String fileName = UUID.randomUUID().toString() + photo.getOriginalFilename();
        Path photoPath = Paths.get(this.uploadDir, fileName);
        Files.write(photoPath, photo.getBytes(), new OpenOption[0]);
        return fileName;
    }

    public String uploadClientPhoto(MultipartFile photo) throws IOException {
        System.out.println("iciiiiii");
        File dir = new File(this.clientPhotoUploadDir);
        if (!dir.exists()) {
            boolean bl = dir.mkdirs();
        }
        String fileName = UUID.randomUUID().toString() + photo.getOriginalFilename();
        Path photoPath = Paths.get(this.clientPhotoUploadDir, fileName);
        Files.write(photoPath, photo.getBytes(), new OpenOption[0]);
        return fileName;
    }

    public String uploadQrCode(BufferedImage qrImage, String codeName) throws IOException {
        File dir = new File(this.clientQrParrainageUploadDir);
        if (!dir.exists()) {
            boolean bl = dir.mkdirs();
        }
        String fileName = "qrcode_" + codeName + ".png";
        File outputFile = new File(dir, fileName);
        ImageIO.write((RenderedImage)qrImage, "png", outputFile);
        return fileName;
    }

    public BufferedImage generateQRCodeImage(String text) throws WriterException {
        HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, 200, 200, hints);
        BufferedImage image = new BufferedImage(200, 200, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 200, 200);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                image.setRGB(i, j, Color.BLACK.getRGB());
            }
        }
        return image;
    }
}

