/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.entities.MessageSujet;
import com.hpay.hpay_mobile_api.services.MessageSujetService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/messages"})
public class MessageSujetController {
    @Autowired
    private MessageSujetService messageSujetService;

    @GetMapping
    public Page<MessageSujet> getMessagesByClient(@RequestParam(value="idclient") Integer idClient, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(required=false) String filtre) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"sujetDate"}).descending());
        if ("lu".equalsIgnoreCase(filtre)) {
            return this.messageSujetService.getMessagesByClientAndLu(idClient, "1", (Pageable)pageable);
        }
        if ("nonlu".equalsIgnoreCase(filtre)) {
            return this.messageSujetService.getMessagesByClientAndLu(idClient, "0", (Pageable)pageable);
        }
        return this.messageSujetService.getMessagesByClient(idClient, (Pageable)pageable);
    }

    @GetMapping(value={"/lire/{id}"})
    public ResponseEntity<MessageSujet> lireMessage(@PathVariable(value="id") Long id) {
        try {
            MessageSujet message = this.messageSujetService.markAsRead(id);
            return ResponseEntity.ok((Object)message);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping(value={"/nonlu/count"})
    public ResponseEntity<?> countMessagesNonLus(@RequestParam(value="idclient") Long idClient) {
        long count = this.messageSujetService.countNonLusByClient(idClient);
        return ResponseEntity.ok().body(Map.of("nonLu", count));
    }

    @PostMapping(value={"/lire-tous"})
    public ResponseEntity<?> markAllAsRead(@RequestParam(value="idclient") Long idClient) {
        int updatedCount = this.messageSujetService.markAllAsReadByClient(idClient);
        return ResponseEntity.ok(Map.of("updated", updatedCount));
    }
}

