/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Pays;
import com.hpay.hpay_mobile_api.services.PayService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pays"})
public class PayController {
    private final PayService payService;

    @Autowired
    public PayController(PayService payService) {
        this.payService = payService;
    }

    @GetMapping
    public ResponseEntity<List<Pays>> getAllPays() {
        List pays = this.payService.getAllPays();
        return new ResponseEntity((Object)pays, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<Pays>> getPaysByName(@RequestParam String pays) {
        List paysList = this.payService.getPayByName(pays);
        if (paysList.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)paysList);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Pays> getPayById(@PathVariable(value="id") Integer id) {
        Optional pay = this.payService.getPayById(id);
        return pay.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Pays> createPay(@RequestBody Pays pay) {
        Pays createdPay = this.payService.createPay(pay);
        return new ResponseEntity((Object)createdPay, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Pays> updatePay(@PathVariable(value="id") Integer id, @RequestBody Pays payDetails) {
        Pays updatedPay = this.payService.updatePay(id, payDetails);
        return new ResponseEntity((Object)updatedPay, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePay(@PathVariable(value="id") Integer id) {
        this.payService.deletePay(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/allwithnocity"})
    public Object getPaysWithoutVilles() {
        Object response = this.payService.getAllPaysWithoutVilles();
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)201).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }
}

