/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.amazonaws.services.s3.AmazonS3;
import com.google.zxing.WriterException;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.LoginRequest;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.entities.Compte;
import com.hpay.hpay_mobile_api.entities.LoginClient;
import com.hpay.hpay_mobile_api.entities.ParrainCode;
import com.hpay.hpay_mobile_api.entities.Parrainage;
import com.hpay.hpay_mobile_api.entities.Pays;
import com.hpay.hpay_mobile_api.entities.TypeCompte;
import com.hpay.hpay_mobile_api.entities.Ville;
import com.hpay.hpay_mobile_api.repositories.ClientRepository;
import com.hpay.hpay_mobile_api.repositories.CompteRepository;
import com.hpay.hpay_mobile_api.repositories.LoginClientRepository;
import com.hpay.hpay_mobile_api.repositories.ParrainCodeRepository;
import com.hpay.hpay_mobile_api.repositories.ParrainageRepository;
import com.hpay.hpay_mobile_api.repositories.PayRepository;
import com.hpay.hpay_mobile_api.repositories.TypeCompteRepository;
import com.hpay.hpay_mobile_api.repositories.VilleRepository;
import com.hpay.hpay_mobile_api.security.JwtTokenUtil;
import com.hpay.hpay_mobile_api.services.ClientService;
import com.hpay.hpay_mobile_api.services.CompteService;
import com.hpay.hpay_mobile_api.services.PhotoService;
import com.hpay.hpay_mobile_api.services.S3Service;
import com.hpay.hpay_mobile_api.utils.PasswordUtils;
import com.hpay.hpay_mobile_api.utils.SMSapi;
import com.hpay.hpay_mobile_api.utils.SendEmail;
import jakarta.mail.MessagingException;
import jakarta.transaction.Transactional;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AuthService {
    @Autowired
    private LoginClientRepository loginClientRepository;
    @Autowired
    private ClientRepository clientRepository;
    @Autowired
    private PayRepository payRepository;
    @Autowired
    private TypeCompteRepository typeCompteRepository;
    @Autowired
    private CompteRepository compteRepository;
    @Autowired
    private ParrainageRepository parrainageRepository;
    @Autowired
    private ParrainCodeRepository parrainageCodeRepository;
    @Autowired
    private S3Service s3Service;
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private PhotoService photoService;
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Value(value="${client.photo.upload-dir}")
    private String uploadDir;
    @Value(value="${client.photo.profile.upload-dir}")
    private String clientPhotoUploadDir;
    @Value(value="${client.photo.profile.base-url}")
    private String clientPhotoBaseUrl;
    @Value(value="${client.photo.base-url}")
    private String photoBaseUrl;
    @Value(value="${client.sponsorship.registration-base-url}")
    private String registrationBaseUrl;
    @Autowired
    private VilleRepository villeRepository;
    @Autowired
    private ClientService clientService;
    @Autowired
    private CompteService compteService;
    @Value(value="${aws.s3.bucketName}")
    private String bucketName;
    private final AmazonS3 amazonS3;

    public AuthService(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    @Transactional
    public Object signup(LoginRequest loginRequest) throws IOException, WriterException {
        Pays pays = this.payRepository.findById((Object)loginRequest.getIdPays()).orElse(null);
        if (pays == null) {
            return new ErrorResponse("Pays not found", 409);
        }
        Ville ville = this.villeRepository.findById((Object)loginRequest.getIdVille()).orElse(null);
        if (ville == null) {
            return new ErrorResponse("Pays not found", 409);
        }
        LoginClient existingClient = this.loginClientRepository.findByLogin(loginRequest.getLogin());
        if (existingClient != null) {
            return new ErrorResponse("Client already exists", 409);
        }
        Date currentDate = new Date();
        String clientCode = "CL12345";
        String numPiece = "123456789";
        Integer idTypePiece = 1;
        Integer idAgence = 2;
        String valider = "0";
        Float gainCommercial = Float.valueOf(0.0f);
        String gainPaye = "0";
        Integer idCommercial = 0;
        Integer idGestionnaire = 0;
        Client client = new Client(clientCode, numPiece, currentDate, ville, idTypePiece, pays, idAgence, valider, gainCommercial, gainPaye, idCommercial, idGestionnaire, loginRequest.getLogin());
        client = (Client)this.clientRepository.save((Object)client);
        ParrainCode parrainCode = new ParrainCode();
        String code = "HPAY_" + client.getId() + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
        while (this.parrainageCodeRepository.findByCodeParrainage(code) != null) {
            code = "HPAY_" + client.getId() + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
        }
        parrainCode.setCodeParrainage(code);
        parrainCode.setUpdate(Boolean.valueOf(false));
        LocalDateTime currentDateTime = LocalDateTime.now();
        parrainCode.setDateCreation(currentDateTime);
        parrainCode.setClient(client);
        String QRCodeText = this.registrationBaseUrl + code;
        BufferedImage qrImage = this.photoService.generateQRCodeImage(QRCodeText);
        String url = this.photoService.uploadQrCode(qrImage, code);
        parrainCode.setQrcode(url);
        parrainCode = (ParrainCode)this.parrainageCodeRepository.save((Object)parrainCode);
        client.setParrainCode(parrainCode);
        client.setValider("2");
        client = (Client)this.clientRepository.save((Object)client);
        String salt = PasswordUtils.generateSalt((int)64);
        String encryptedPassword = PasswordUtils.hashPassword((String)loginRequest.getPassword(), (String)salt);
        LoginClient loginClient = new LoginClient();
        loginClient.setLogin(loginRequest.getLogin());
        loginClient.setPassword(encryptedPassword);
        loginClient.setSalt(salt);
        loginClient.setUsername(loginRequest.getLogin());
        loginClient.setActif("0");
        Random rand = new Random();
        int randomNum = 1000 + rand.nextInt(9000);
        String activationCode = String.valueOf(randomNum);
        loginClient.setActivationCode(activationCode);
        loginClient.setClient(client);
        loginClient.setEmailvalidate("0");
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        SMSapi sms = new SMSapi();
        sms.alaSMS(pays.getIndicatif() + loginRequest.getLogin(), "Hpay: votre code de v\u00e9rification  est " + activationCode + " Ne le partargez pas. Si vous ne l'avez pas demand\u00e9 veillez ignorer ce message.");
        return new SuccessResponse("User registered successfully", 201, map);
    }

    public static boolean contientTypeCompte(List<Compte> comptes, int idTypeCompteRecherche) {
        for (Compte compte : comptes) {
            if (compte.getTypeCompte().getTypeCompte() == null || compte.getTypeCompte().getIdTypeCompte() != idTypeCompteRecherche) continue;
            return true;
        }
        return false;
    }

    public Object signin(String login, String password) throws IOException, WriterException {
        LoginClient loginClient = this.loginClientRepository.findByLogin(login);
        Client client = loginClient.getClient();
        if (loginClient == null) {
            return new ErrorResponse("Invalid credentials", 401);
        }
        List compteClients = loginClient.getClient().getComptes();
        Date today = new Date();
        if (loginClient.getClient().getParrainCode() == null) {
            ParrainCode parrainCode = new ParrainCode();
            String code = "HPAY_" + loginClient.getClient().getId() + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
            while (this.parrainageCodeRepository.findByCodeParrainage(code) != null) {
                code = "HPAY_" + loginClient.getClient().getId() + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
            }
            parrainCode.setCodeParrainage(code);
            parrainCode.setUpdate(Boolean.valueOf(false));
            LocalDateTime currentDateTime = LocalDateTime.now();
            parrainCode.setDateCreation(currentDateTime);
            parrainCode.setClient(loginClient.getClient());
            String QRCodeText = this.registrationBaseUrl + code;
            BufferedImage qrImage = this.photoService.generateQRCodeImage(QRCodeText);
            String url = this.photoService.uploadQrCode(qrImage, code);
            parrainCode.setQrcode(url);
            parrainCode = (ParrainCode)this.parrainageCodeRepository.save((Object)parrainCode);
            client.setParrainCode(parrainCode);
        }
        if (!AuthService.contientTypeCompte((List)compteClients, (int)4) && !loginClient.getClient().getPays().getDevise().getDevise().equals("EUR")) {
            TypeCompte EURCompteType = this.typeCompteRepository.findById((Object)4L).orElse(null);
            if (EURCompteType == null) {
                return new ErrorResponse("type compte EUR   not found", 404);
            }
            Compte EURCompte = new Compte();
            LocalDateTime now4 = LocalDateTime.now();
            DateTimeFormatter formatter4 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            EURCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            EURCompte.setSolde(new BigDecimal("0"));
            EURCompte.setRib("#");
            EURCompte.setIban("#");
            EURCompte.setBicSwift("#");
            EURCompte.setCompteSuspendu("0");
            EURCompte.setPays(loginClient.getClient().getPays());
            EURCompte.setDevise("EUR");
            EURCompte.setCloture("0");
            EURCompte.setClient(loginClient.getClient());
            EURCompte.setTypeCompte(EURCompteType);
            EURCompte.setFraisCreationCpt(new BigDecimal("0"));
            EURCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)EURCompte);
            compteClients.add(EURCompte);
        }
        if (!AuthService.contientTypeCompte((List)compteClients, (int)1) && !loginClient.getClient().getPays().getDevise().getDevise().equals("USD")) {
            TypeCompte USDCompteType = this.typeCompteRepository.findById((Object)1L).orElse(null);
            if (USDCompteType == null) {
                return new ErrorResponse("type compte USD   not found", 404);
            }
            Compte USDCompte = new Compte();
            LocalDateTime now2 = LocalDateTime.now();
            DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            USDCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            USDCompte.setSolde(new BigDecimal("0"));
            USDCompte.setRib("#");
            USDCompte.setIban("#");
            USDCompte.setBicSwift("#");
            USDCompte.setCompteSuspendu("0");
            USDCompte.setPays(loginClient.getClient().getPays());
            USDCompte.setDevise("USD");
            USDCompte.setCloture("0");
            USDCompte.setClient(loginClient.getClient());
            USDCompte.setTypeCompte(USDCompteType);
            USDCompte.setFraisCreationCpt(new BigDecimal("0"));
            USDCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)USDCompte);
            compteClients.add(USDCompte);
        }
        if (!AuthService.contientTypeCompte((List)compteClients, (int)3) && !loginClient.getClient().getPays().getDevise().getDevise().equals("CAD")) {
            TypeCompte CADCompteType = this.typeCompteRepository.findById((Object)3L).orElse(null);
            if (CADCompteType == null) {
                return new ErrorResponse("type compte CAD   not found", 404);
            }
            Compte CADCompte = new Compte();
            LocalDateTime now3 = LocalDateTime.now();
            DateTimeFormatter formatter3 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            CADCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            CADCompte.setSolde(new BigDecimal("0"));
            CADCompte.setRib("#");
            CADCompte.setIban("#");
            CADCompte.setBicSwift("#");
            CADCompte.setCompteSuspendu("0");
            CADCompte.setPays(loginClient.getClient().getPays());
            CADCompte.setDevise("CAD");
            CADCompte.setCloture("0");
            CADCompte.setClient(loginClient.getClient());
            CADCompte.setTypeCompte(CADCompteType);
            CADCompte.setFraisCreationCpt(new BigDecimal("0"));
            CADCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)CADCompte);
            compteClients.add(CADCompte);
        }
        if (!AuthService.contientTypeCompte((List)compteClients, (int)5) && !loginClient.getClient().getPays().getDevise().getDevise().equals("GBP")) {
            TypeCompte GBPCompteType = this.typeCompteRepository.findById((Object)5L).orElse(null);
            if (GBPCompteType == null) {
                return new ErrorResponse("type compte GBP   not found", 404);
            }
            Compte GBPCompte = new Compte();
            LocalDateTime now5 = LocalDateTime.now();
            DateTimeFormatter formatter5 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            GBPCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            GBPCompte.setSolde(new BigDecimal("0"));
            GBPCompte.setRib("#");
            GBPCompte.setIban("#");
            GBPCompte.setBicSwift("#");
            GBPCompte.setCompteSuspendu("0");
            GBPCompte.setPays(loginClient.getClient().getPays());
            GBPCompte.setDevise("GBP");
            GBPCompte.setCloture("0");
            GBPCompte.setClient(loginClient.getClient());
            GBPCompte.setTypeCompte(GBPCompteType);
            GBPCompte.setFraisCreationCpt(new BigDecimal("0"));
            GBPCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)GBPCompte);
            compteClients.add(GBPCompte);
        }
        client.setComptes(compteClients);
        loginClient.setClient(client);
        this.loginClientRepository.save((Object)loginClient);
        Random rand = new Random();
        int randomNum = 1000 + rand.nextInt(9000);
        String activationCode = String.valueOf(randomNum);
        String hashedInput = PasswordUtils.hashPassword((String)password, (String)loginClient.getSalt());
        if (hashedInput.equals(loginClient.getPassword())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String data = "data";
            map.put(data, loginClient);
            map.put("token", this.jwtTokenUtil.generateToken(loginClient.getLogin()));
            if (!loginClient.getActif().equals("1")) {
                SMSapi sms = new SMSapi();
                sms.alaSMS(loginClient.getClient().getPays().getIndicatif() + loginClient.getLogin(), "Hpay: votre code de v\u00e9rification  est " + activationCode + " Ne le partargez pas. Si vous ne l'avez pas demand\u00e9 veillez ignorer ce message.");
            }
            return new SuccessResponse("Sign-in successful", 200, map);
        }
        return new ErrorResponse("Invalid credentials", 401);
    }

    @Transactional
    public Object validateLoginClient(Long idLoginClient, String activationCode) {
        Date today = new Date();
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (loginClient.getActivationCode().equals(activationCode)) {
            loginClient.setActif("1");
            TypeCompte hpayCashCompteType = this.typeCompteRepository.findById((Object)2L).orElse(null);
            if (hpayCashCompteType == null) {
                return new ErrorResponse("type compte Hpay cash  not found", 404);
            }
            TypeCompte personalCompteType = this.typeCompteRepository.findById((Object)6L).orElse(null);
            if (personalCompteType == null) {
                return new ErrorResponse("type compte personnel   not found", 404);
            }
            TypeCompte CADCompteType = this.typeCompteRepository.findById((Object)3L).orElse(null);
            if (CADCompteType == null) {
                return new ErrorResponse("type compte CAD   not found", 404);
            }
            TypeCompte EURCompteType = this.typeCompteRepository.findById((Object)4L).orElse(null);
            if (EURCompteType == null) {
                return new ErrorResponse("type compte EUR   not found", 404);
            }
            TypeCompte USDCompteType = this.typeCompteRepository.findById((Object)1L).orElse(null);
            if (USDCompteType == null) {
                return new ErrorResponse("type compte USD   not found", 404);
            }
            TypeCompte GBPCompteType = this.typeCompteRepository.findById((Object)5L).orElse(null);
            if (GBPCompteType == null) {
                return new ErrorResponse("type compte GBP   not found", 404);
            }
            Compte hpayCashCompte = new Compte();
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            hpayCashCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            hpayCashCompte.setSolde(new BigDecimal("0"));
            hpayCashCompte.setRib("#");
            hpayCashCompte.setIban("#");
            hpayCashCompte.setBicSwift("#");
            hpayCashCompte.setCompteSuspendu("0");
            hpayCashCompte.setPays(loginClient.getClient().getPays());
            hpayCashCompte.setDevise("HPC");
            hpayCashCompte.setCloture("0");
            hpayCashCompte.setClient(loginClient.getClient());
            hpayCashCompte.setTypeCompte(hpayCashCompteType);
            hpayCashCompte.setFraisCreationCpt(new BigDecimal("0"));
            hpayCashCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)hpayCashCompte);
            Compte personnalCompte = new Compte();
            LocalDateTime now1 = LocalDateTime.now().plusSeconds(1L);
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
            personnalCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
            personnalCompte.setSolde(new BigDecimal("0"));
            personnalCompte.setRib("#");
            personnalCompte.setIban("#");
            personnalCompte.setBicSwift("#");
            personnalCompte.setCompteSuspendu("0");
            personnalCompte.setPays(loginClient.getClient().getPays());
            personnalCompte.setDevise(loginClient.getClient().getPays().getDevise().getDevise());
            personnalCompte.setCloture("0");
            personnalCompte.setClient(loginClient.getClient());
            personnalCompte.setTypeCompte(personalCompteType);
            personnalCompte.setFraisCreationCpt(new BigDecimal("0"));
            personnalCompte.setDateCreationCpt(today);
            this.compteRepository.save((Object)personnalCompte);
            ArrayList<Compte> comptes = new ArrayList<Compte>();
            comptes.add(hpayCashCompte);
            comptes.add(personnalCompte);
            if (!loginClient.getClient().getPays().getDevise().getDevise().equals("USD")) {
                Compte USDCompte = new Compte();
                LocalDateTime now2 = LocalDateTime.now();
                DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
                USDCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
                USDCompte.setSolde(new BigDecimal("0"));
                USDCompte.setRib("#");
                USDCompte.setIban("#");
                USDCompte.setBicSwift("#");
                USDCompte.setCompteSuspendu("0");
                USDCompte.setPays(loginClient.getClient().getPays());
                USDCompte.setDevise("USD");
                USDCompte.setCloture("0");
                USDCompte.setClient(loginClient.getClient());
                USDCompte.setTypeCompte(USDCompteType);
                USDCompte.setFraisCreationCpt(new BigDecimal("0"));
                USDCompte.setDateCreationCpt(today);
                this.compteRepository.save((Object)USDCompte);
                comptes.add(USDCompte);
            }
            if (!loginClient.getClient().getPays().getDevise().getDevise().equals("CAD")) {
                Compte CADCompte = new Compte();
                LocalDateTime now3 = LocalDateTime.now();
                DateTimeFormatter formatter3 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
                CADCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
                CADCompte.setSolde(new BigDecimal("0"));
                CADCompte.setRib("#");
                CADCompte.setIban("#");
                CADCompte.setBicSwift("#");
                CADCompte.setCompteSuspendu("0");
                CADCompte.setPays(loginClient.getClient().getPays());
                CADCompte.setDevise("CAD");
                CADCompte.setCloture("0");
                CADCompte.setClient(loginClient.getClient());
                CADCompte.setTypeCompte(CADCompteType);
                CADCompte.setFraisCreationCpt(new BigDecimal("0"));
                CADCompte.setDateCreationCpt(today);
                this.compteRepository.save((Object)CADCompte);
                comptes.add(CADCompte);
            }
            if (!loginClient.getClient().getPays().getDevise().getDevise().equals("EUR")) {
                Compte EURCompte = new Compte();
                LocalDateTime now4 = LocalDateTime.now();
                DateTimeFormatter formatter4 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
                EURCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
                EURCompte.setSolde(new BigDecimal("0"));
                EURCompte.setRib("#");
                EURCompte.setIban("#");
                EURCompte.setBicSwift("#");
                EURCompte.setCompteSuspendu("0");
                EURCompte.setPays(loginClient.getClient().getPays());
                EURCompte.setDevise("EUR");
                EURCompte.setCloture("0");
                EURCompte.setClient(loginClient.getClient());
                EURCompte.setTypeCompte(EURCompteType);
                EURCompte.setFraisCreationCpt(new BigDecimal("0"));
                EURCompte.setDateCreationCpt(today);
                this.compteRepository.save((Object)EURCompte);
                comptes.add(EURCompte);
            }
            if (!loginClient.getClient().getPays().getDevise().getDevise().equals("GBP")) {
                Compte GBPCompte = new Compte();
                LocalDateTime now5 = LocalDateTime.now();
                DateTimeFormatter formatter5 = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
                GBPCompte.setNumCompte(this.compteService.generateUniqueNumCompte());
                GBPCompte.setSolde(new BigDecimal("0"));
                GBPCompte.setRib("#");
                GBPCompte.setIban("#");
                GBPCompte.setBicSwift("#");
                GBPCompte.setCompteSuspendu("0");
                GBPCompte.setPays(loginClient.getClient().getPays());
                GBPCompte.setDevise("GBP");
                GBPCompte.setCloture("0");
                GBPCompte.setClient(loginClient.getClient());
                GBPCompte.setTypeCompte(GBPCompteType);
                GBPCompte.setFraisCreationCpt(new BigDecimal("0"));
                GBPCompte.setDateCreationCpt(today);
                this.compteRepository.save((Object)GBPCompte);
                comptes.add(GBPCompte);
            }
            Client client = loginClient.getClient();
            client.setComptes(comptes);
            loginClient.setClient(client);
            LoginClient loginClient1 = (LoginClient)this.loginClientRepository.save((Object)loginClient);
            HashMap map = new HashMap();
            return new SuccessResponse("validate successful", 200, map);
        }
        return new ErrorResponse("Invalid code", 401);
    }

    @Transactional
    public Object updateActivationCode(Long idLoginClient) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        Random rand = new Random();
        int randomNum = 1000 + rand.nextInt(9000);
        String activationCode = String.valueOf(randomNum);
        loginClient.setActivationCode(activationCode);
        SMSapi sms = new SMSapi();
        sms.alaSMS(loginClient.getLogin(), "Hpay: votre code de v\u00e9rification  est " + activationCode + " Ne le partargez pas. Si vous ne l'avez pas demand\u00e9 veillez ignorer ce message.");
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("update succesful", 200, map);
    }

    @Transactional
    public Object updateClientInfo(Long idLoginClient, String nom, String prenoms, String sex, Date dateNaissance, String lieuNaissance) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        Client client = loginClient.getClient();
        client.setNom(nom);
        client.setPrenoms(prenoms);
        client.setDateNaissance(dateNaissance);
        client.setLieuNaissane(lieuNaissance);
        client.setSexe(sex);
        loginClient.setClient(client);
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("update succesfull", 200, map);
    }

    @Transactional
    public Object updateEmail(Long idLoginClient, String email) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        Client existClient = this.clientService.getClientByEmail(email);
        if (existClient != null && !existClient.getId().equals(loginClient.getClient().getId())) {
            return new ErrorResponse("email already used", 404);
        }
        Client client = loginClient.getClient();
        client.setEmail(email);
        loginClient.setClient(client);
        Random rand = new Random();
        int randomNum = 1000 + rand.nextInt(9000);
        String activationCode = String.valueOf(randomNum);
        loginClient.setActivationCode(activationCode);
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        try {
            SendEmail.sendEmailValidationCode((String)email, (String)activationCode, (String)client.getPrenoms());
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("update succesfull", 200, map);
    }

    @Transactional
    public Object uploadClientPhoto(Long idLoginClient, MultipartFile photo) throws IOException, ParseException {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        String photoUrl = this.photoService.uploadClientPhoto(photo);
        Client client = loginClient.getClient();
        client.setPhotoClient(photoUrl);
        loginClient.setClient(client);
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("update photo added", 200, map);
    }

    @Transactional
    public Object validateEmailClient(Long idLoginClient, String activationCode) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (loginClient.getActivationCode().equals(activationCode)) {
            loginClient.setEmailvalidate("1");
            this.loginClientRepository.save((Object)loginClient);
            try {
                SendEmail.sendAccountCreatedConfirmEmail((String)loginClient.getClient().getEmail(), (String)loginClient.getClient().getPrenoms(), (String)String.valueOf(loginClient.getLogin()));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            HashMap map = new HashMap();
            return new SuccessResponse("validate successful", 200, map);
        }
        return new ErrorResponse("not correct code", 404);
    }

    public Object deleteLoginClient(Long id) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)id).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        this.loginClientRepository.deleteById((Object)id);
        HashMap map = new HashMap();
        return new SuccessResponse("delete succesfull", 200, map);
    }

    public Object fetchClient(Long id) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)id).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("delete succesfull", 200, map);
    }

    public Object passwordforgetRequest(String phone) {
        LoginClient loginClient = this.loginClientRepository.findByLogin(phone);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        Random rand = new Random();
        int randomNum = 1000 + rand.nextInt(9000);
        String activationCode = String.valueOf(randomNum);
        loginClient.setActivationCode(activationCode);
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        System.out.println(phone);
        SMSapi sms = new SMSapi();
        sms.alaSMS(phone, "Hpay: Le  code restauration de votre  mot de passe est " + activationCode + ". Ne le partargez pas. Si vous ne l'avez pas demand\u00e9 veillez ignorer ce message.");
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("update succesfull", 200, map);
    }

    public Object validatePasswordForgotCode(String phone, String activationCode) {
        LoginClient loginClient = this.loginClientRepository.findByLogin(phone);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (loginClient.getActivationCode().equals(activationCode)) {
            HashMap map = new HashMap();
            return new SuccessResponse("validate successful", 200, map);
        }
        return new ErrorResponse("Invalid code", 401);
    }

    public Object changepassword(String phone, String password) {
        LoginClient loginClient = this.loginClientRepository.findByLogin(phone);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        String salt = PasswordUtils.generateSalt((int)64);
        String encryptedPassword = PasswordUtils.hashPassword((String)password, (String)salt);
        loginClient.setSalt(salt);
        loginClient.setPassword(encryptedPassword);
        loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("password update succeffully", 201, map);
    }

    public Object changePasswordWithOldPassword(Long id, String oldPassword, String newPassword) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)id).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        if (this.passwordEncoder.matches((CharSequence)oldPassword, loginClient.getPassword())) {
            String salt = UUID.randomUUID().toString();
            String encryptedPassword = this.passwordEncoder.encode((CharSequence)newPassword);
            loginClient.setPassword(encryptedPassword);
            loginClient = (LoginClient)this.loginClientRepository.save((Object)loginClient);
            HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
            map.put("data", loginClient);
            return new SuccessResponse("password successfully update", 200, map);
        }
        return new ErrorResponse("Invalid credentials", 401);
    }

    public Object fetchClientByPhone(String phone) {
        LoginClient loginClient = this.loginClientRepository.findByLogin(phone);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        HashMap<String, LoginClient> map = new HashMap<String, LoginClient>();
        map.put("data", loginClient);
        return new SuccessResponse("client found", 200, map);
    }

    public Object addParrainage(String parrainePhone, String parrainPhone) {
        LoginClient loginparrain = this.loginClientRepository.findByUsername(parrainPhone);
        if (loginparrain == null) {
            return new ErrorResponse("parrain not found", 404);
        }
        LoginClient loginParraine = this.loginClientRepository.findByUsername(parrainePhone);
        if (loginParraine == null) {
            return new ErrorResponse("parraine not found", 404);
        }
        if (loginparrain.equals(loginParraine)) {
            return new ErrorResponse("parrainage already exist", 404);
        }
        Parrainage parrainnage = this.parrainageRepository.findByParrainAndParrainee(loginparrain.getClient(), loginParraine.getClient());
        if (parrainnage != null) {
            return new ErrorResponse("parrainage already exist", 404);
        }
        Parrainage parrainage = new Parrainage();
        parrainage.setParrain(loginparrain.getClient());
        parrainage.setParrainee(loginParraine.getClient());
        parrainage.setParrainDetails("ras");
        parrainage.setParrainMontantPaye(0.0f);
        parrainage.setParrainPaye("0");
        this.parrainageRepository.save((Object)parrainage);
        Client clientParraine = loginParraine.getClient();
        clientParraine.setIdAgence(loginparrain.getClient().getIdAgence());
        this.clientRepository.save((Object)clientParraine);
        HashMap map = new HashMap();
        return new SuccessResponse("parrainage added", 200, map);
    }

    public Object fetchClientByCodeParrainage(String code) {
        ParrainCode parrainCode = this.parrainageCodeRepository.findByCodeParrainage(code);
        if (parrainCode == null) {
            return new ErrorResponse("Client not found", 404);
        }
        Client client = parrainCode.getClient();
        HashMap<String, Client> map = new HashMap<String, Client>();
        map.put("data", client);
        return new SuccessResponse("client found", 200, map);
    }

    @Transactional
    public Object sendEmailValiderClient(Long idLoginClient) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        HashMap map = new HashMap();
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        try {
            SendEmail.sendEmailValidationCode((String)loginClient.getClient().getPrenoms(), (String)loginClient.getClient().getNom(), (Long)loginClient.getClient().getId());
            return new SuccessResponse("send successful", 200, map);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return new ErrorResponse("not correct code", 404);
        }
    }

    @Transactional
    public Object accountCreatedConfirm(Long idLoginClient) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("Client not found", 404);
        }
        try {
            SendEmail.sendAccountCreatedConfirmEmail((String)"onanajunior92@gmail.com", (String)loginClient.getClient().getPrenoms(), (String)String.valueOf(loginClient.getLogin()));
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap map = new HashMap();
        return new SuccessResponse("email ", 200, map);
    }
}

