/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.CarteClientQrDTO;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.CarteClientQr;
import com.hpay.hpay_mobile_api.entities.CarteGeneree;
import com.hpay.hpay_mobile_api.entities.Compte;
import com.hpay.hpay_mobile_api.entities.HistoriqueCartes;
import com.hpay.hpay_mobile_api.entities.LoginClient;
import com.hpay.hpay_mobile_api.repositories.CarteClientQrRepository;
import com.hpay.hpay_mobile_api.repositories.CarteGenereeRepository;
import com.hpay.hpay_mobile_api.repositories.CompteRepository;
import com.hpay.hpay_mobile_api.repositories.HistoriqueCartesRepository;
import com.hpay.hpay_mobile_api.repositories.LoginClientRepository;
import com.hpay.hpay_mobile_api.utils.SMSapi;
import com.hpay.hpay_mobile_api.utils.SendEmail;
import jakarta.mail.MessagingException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CarteClientQrService {
    @Autowired
    private CarteClientQrRepository carteClientQrRepository;
    @Autowired
    private CompteRepository compteRepository;
    @Autowired
    CarteGenereeRepository carteGenereeRepository;
    @Autowired
    private LoginClientRepository loginClientRepository;
    @Autowired
    private HistoriqueCartesRepository historiqueCartesRepository;

    public Object ajouterCarteAuCompte(Long idCompte, Long idLoginClient, CarteClientQrDTO carteClientQrDTO) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("client not found", 401);
        }
        if (!loginClient.getClient().getValider().equals("1")) {
            return new ErrorResponse("client not validate", 401);
        }
        Compte compte = this.compteRepository.findById((Object)idCompte).orElse(null);
        if (compte == null) {
            return new ErrorResponse("Account not found", 404);
        }
        Optional carteOptional = this.carteGenereeRepository.findByNumCarte(carteClientQrDTO.getNumCarte());
        if (carteOptional.isEmpty()) {
            return new ErrorResponse("Card not found", 404);
        }
        CarteGeneree carte = (CarteGeneree)carteOptional.get();
        Date currentDate = new Date();
        if (!carte.getDateValidite().after(currentDate)) {
            return new ErrorResponse("Card expired", 404);
        }
        if (carte.getUtilisee().booleanValue()) {
            return new ErrorResponse("Card Dej\u00e0 utilis\u00e9", 404);
        }
        if (!carte.getPin().equals(carteClientQrDTO.getPin())) {
            return new ErrorResponse("not valid code pin", 404);
        }
        if (compte.getCarteClientQr() != null) {
            return new ErrorResponse("Card already linked", 404);
        }
        CarteClientQr carteClientQr = new CarteClientQr();
        carteClientQr.setNumCarte(carteClientQrDTO.getNumCarte());
        carteClientQr.setFrais(carteClientQrDTO.getFrais());
        carteClientQr.setDateCreation(carte.getDateGeneration());
        carteClientQr.setDateExpire(carte.getDateValidite());
        carteClientQr.setPin(carteClientQrDTO.getPin());
        carteClientQr.setTypeCarte(carteClientQrDTO.getTypeCarte());
        carteClientQr.setIdAgence(carteClientQrDTO.getIdAgence());
        carteClientQr.setIdCommercial(carteClientQrDTO.getIdCommercial());
        carteClientQr.setIdGestionnaire(carteClientQrDTO.getIdGestionnaire());
        carteClientQr.setIdClients(carteClientQrDTO.getIdClients());
        carteClientQr.setActif("1");
        carteClientQr.setCompte(compte);
        HistoriqueCartes historiqueCartes = new HistoriqueCartes();
        historiqueCartes.setAction("Ajout");
        historiqueCartes.setDetails("Ajout de la carte pour le client.");
        historiqueCartes.setIp(carteClientQrDTO.getIp());
        historiqueCartes.setIdclients(loginClient.getClient().getId());
        historiqueCartes.setDateAction(LocalDateTime.now());
        historiqueCartes.setNumCarte(carteClientQr.getNumCarte());
        carte.setUtilisee(Boolean.valueOf(true));
        this.carteGenereeRepository.save((Object)carte);
        carteClientQr = (CarteClientQr)this.carteClientQrRepository.save((Object)carteClientQr);
        this.historiqueCartesRepository.save((Object)historiqueCartes);
        SMSapi sms = new SMSapi();
        sms.alaSMS(loginClient.getClient().getPays().getIndicatif() + loginClient.getLogin(), "Une carte de num\u00e9ro " + carte.getNumCarte() + " a \u00e9t\u00e9 ajout\u00e9e \u00e0 votre compte. Si ce n'est pas vous, contactez le support.");
        try {
            LocalDate currentDate1 = LocalDate.now();
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDate = currentDate1.format(formatter1);
            LocalTime currentTime = LocalTime.now();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mm");
            String formattedTime = currentTime.format(timeFormatter);
            SendEmail.sendEmailAddCard((String)loginClient.getClient().getEmail(), (String)loginClient.getClient().getPrenoms(), (String)carte.getNumCarte(), (String)formattedDate, (String)formattedTime);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap<String, CarteClientQr> map = new HashMap<String, CarteClientQr>();
        map.put("data", carteClientQr);
        return new SuccessResponse("card succesffully added", 200, map);
    }

    public Object modifyPinCompte(Long idCompte, Long idLoginClient, CarteClientQrDTO carteClientQrDTO) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("client not found", 401);
        }
        if (!loginClient.getClient().getValider().equals("1")) {
            return new ErrorResponse("client not validate", 401);
        }
        Compte compte = this.compteRepository.findById((Object)idCompte).orElse(null);
        if (compte == null) {
            return new ErrorResponse("Account not found", 404);
        }
        CarteClientQr existingCardClientQr = compte.getCarteClientQr();
        if (existingCardClientQr == null) {
            return new ErrorResponse("Card not exist", 404);
        }
        Optional carteOptional = this.carteGenereeRepository.findByNumCarte(existingCardClientQr.getNumCarte());
        if (carteOptional.isEmpty()) {
            return new ErrorResponse("Card not found", 404);
        }
        CarteGeneree carte = (CarteGeneree)carteOptional.get();
        carte.setPin(carteClientQrDTO.getPin());
        this.carteGenereeRepository.save((Object)carte);
        existingCardClientQr.setPin(carteClientQrDTO.getPin());
        existingCardClientQr.setCompte(compte);
        HistoriqueCartes historiqueCartes = new HistoriqueCartes();
        historiqueCartes.setAction("Changement PIN");
        historiqueCartes.setDetails("Changement du code pin li\u00e9 \u00e0 la carte");
        historiqueCartes.setIp(carteClientQrDTO.getIp());
        historiqueCartes.setIdclients(loginClient.getClient().getId());
        historiqueCartes.setDateAction(LocalDateTime.now());
        historiqueCartes.setNumCarte(existingCardClientQr.getNumCarte());
        existingCardClientQr = (CarteClientQr)this.carteClientQrRepository.save((Object)existingCardClientQr);
        this.historiqueCartesRepository.save((Object)historiqueCartes);
        SMSapi sms = new SMSapi();
        sms.alaSMS(loginClient.getClient().getPays().getIndicatif() + loginClient.getLogin(), "Le code PIN de votre carte HPay " + carte.getNumCarte() + " a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s");
        try {
            LocalDate currentDate1 = LocalDate.now();
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDate = currentDate1.format(formatter1);
            LocalTime currentTime = LocalTime.now();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mm");
            String formattedTime = currentTime.format(timeFormatter);
            SendEmail.sendEmailModifyPinCard((String)loginClient.getClient().getEmail(), (String)loginClient.getClient().getPrenoms(), (String)carte.getNumCarte(), (String)formattedDate, (String)formattedTime);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap<String, CarteClientQr> map = new HashMap<String, CarteClientQr>();
        map.put("data", existingCardClientQr);
        return new SuccessResponse("Card succesffully added", 200, map);
    }

    public Object removeCardCompte(Long idcarteClientQr, Long idLoginClient, CarteClientQrDTO carteClientQrDTO) {
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("client not found", 401);
        }
        if (!loginClient.getClient().getValider().equals("1")) {
            return new ErrorResponse("client not validate", 401);
        }
        CarteClientQr carteClientQr = this.carteClientQrRepository.findById((Object)idcarteClientQr).orElse(null);
        if (carteClientQr == null) {
            return new ErrorResponse("card not found", 404);
        }
        Optional carteOptional = this.carteGenereeRepository.findByNumCarte(carteClientQr.getNumCarte());
        if (carteOptional.isEmpty()) {
            return new ErrorResponse("Card not found", 404);
        }
        CarteGeneree carte = (CarteGeneree)carteOptional.get();
        carte.setUtilisee(Boolean.valueOf(false));
        HistoriqueCartes historiqueCartes = new HistoriqueCartes();
        historiqueCartes.setAction("Changement PIN");
        historiqueCartes.setDetails("Changement du code pin li\u00e9 \u00e0 la carte");
        historiqueCartes.setIp(carteClientQrDTO.getIp());
        historiqueCartes.setIdclients(loginClient.getClient().getId());
        historiqueCartes.setDateAction(LocalDateTime.now());
        historiqueCartes.setNumCarte(carteClientQr.getNumCarte());
        this.carteClientQrRepository.deleteById((Object)idcarteClientQr);
        this.carteGenereeRepository.save((Object)carte);
        this.historiqueCartesRepository.save((Object)historiqueCartes);
        SMSapi sms = new SMSapi();
        sms.alaSMS(loginClient.getClient().getPays().getIndicatif() + loginClient.getLogin(), "HPay : La carte HPay num\u00e9ro " + carte.getNumCarte() + " a \u00e9t\u00e9 retir\u00e9e de votre compte. Si ce n'est pas vous, contactez le support.");
        try {
            LocalDate currentDate1 = LocalDate.now();
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDate = currentDate1.format(formatter1);
            LocalTime currentTime = LocalTime.now();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mm");
            String formattedTime = currentTime.format(timeFormatter);
            SendEmail.sendEmailRemoveCard((String)loginClient.getClient().getEmail(), (String)loginClient.getClient().getPrenoms(), (String)carte.getNumCarte(), (String)formattedDate, (String)formattedTime);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", null);
        return new SuccessResponse("Card succesffully deleted", 200, map);
    }

    public Object toggleActiveCompte(Long idCompte, Long idLoginClient, CarteClientQrDTO carteClientQrDTO) {
        HistoriqueCartes historiqueCartes;
        LoginClient loginClient = this.loginClientRepository.findById((Object)idLoginClient).orElse(null);
        if (loginClient == null) {
            return new ErrorResponse("client not found", 401);
        }
        if (!loginClient.getClient().getValider().equals("1")) {
            return new ErrorResponse("client not validate", 401);
        }
        Compte compte = this.compteRepository.findById((Object)idCompte).orElse(null);
        if (compte == null) {
            return new ErrorResponse("Account not found", 404);
        }
        CarteClientQr existingCardClientQr = compte.getCarteClientQr();
        if (existingCardClientQr == null) {
            return new ErrorResponse("Card not exist", 404);
        }
        if (existingCardClientQr.getActif().equals("1")) {
            existingCardClientQr.setActif("0");
            existingCardClientQr.setCompte(compte);
            existingCardClientQr = (CarteClientQr)this.carteClientQrRepository.save((Object)existingCardClientQr);
            historiqueCartes = new HistoriqueCartes();
            historiqueCartes.setAction("D\u00e9sactivation");
            historiqueCartes.setDetails("D\u00e9sactivation  du code Pin");
            historiqueCartes.setIp(carteClientQrDTO.getIp());
            historiqueCartes.setIdclients(loginClient.getClient().getId());
            historiqueCartes.setDateAction(LocalDateTime.now());
            historiqueCartes.setNumCarte(existingCardClientQr.getNumCarte());
            this.historiqueCartesRepository.save((Object)historiqueCartes);
        } else {
            existingCardClientQr.setActif("1");
            existingCardClientQr.setCompte(compte);
            existingCardClientQr = (CarteClientQr)this.carteClientQrRepository.save((Object)existingCardClientQr);
            historiqueCartes = new HistoriqueCartes();
            historiqueCartes.setAction("Activation");
            historiqueCartes.setDetails("Activation du code Pin");
            historiqueCartes.setIp(carteClientQrDTO.getIp());
            historiqueCartes.setIdclients(loginClient.getClient().getId());
            historiqueCartes.setDateAction(LocalDateTime.now());
            historiqueCartes.setNumCarte(existingCardClientQr.getNumCarte());
            this.historiqueCartesRepository.save((Object)historiqueCartes);
        }
        historiqueCartes = new HistoriqueCartes();
        historiqueCartes.setAction("Changement PIN");
        historiqueCartes.setDetails("Changement du code pin li\u00e9 \u00e0 la carte");
        historiqueCartes.setIp(carteClientQrDTO.getIp());
        historiqueCartes.setIdclients(loginClient.getClient().getId());
        historiqueCartes.setDateAction(LocalDateTime.now());
        historiqueCartes.setNumCarte(existingCardClientQr.getNumCarte());
        this.historiqueCartesRepository.save((Object)historiqueCartes);
        HashMap<String, CarteClientQr> map = new HashMap<String, CarteClientQr>();
        map.put("data", existingCardClientQr);
        return new SuccessResponse("Carte Activ\u00e9/d\u00e9sactiv\u00e9", 200, map);
    }
}

